/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;
import net.adventurez.entity.DragonEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

@Environment(value=EnvType.CLIENT)
public class DragonModel<T extends DragonEntity>
extends ListModel<T> {
    private final ModelPart body;
    private final ModelPart chest;
    private final ModelPart spike;
    private final ModelPart wingLeft;
    private final ModelPart wingTipLeft;
    private final ModelPart wingRight;
    private final ModelPart wingTipRight;
    private final ModelPart rearLegRight;
    private final ModelPart rearLegRightTip;
    private final ModelPart rearLegRightTip_r1;
    private final ModelPart rearFootRight;
    private final ModelPart rearLegLeft;
    private final ModelPart rearLegLefttip;
    private final ModelPart rearLegLefttip_r1;
    private final ModelPart rearFootLeft;
    private final ModelPart frontLegRight;
    private final ModelPart frontLegRight_r1;
    private final ModelPart frontLegRighttip;
    private final ModelPart frontLegRighttip_r1;
    private final ModelPart frontFootRight;
    private final ModelPart frontLegLeft;
    private final ModelPart frontLegLeft_r1;
    private final ModelPart frontLegLefttip;
    private final ModelPart frontLegLefttip_r1;
    private final ModelPart frontFootLeft;
    private final ModelPart neck;
    private final ModelPart neck2;
    private final ModelPart neck3;
    private final ModelPart neck4;
    private final ModelPart head;
    private final ModelPart otherEars;
    private final ModelPart otherEars_r1;
    private final ModelPart otherEars_r2;
    private final ModelPart ears;
    private final ModelPart jaw;
    private final ModelPart tail;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart tail4;
    private final ModelPart tail5;
    private final ModelPart tail6;
    private final ModelPart otherTail;
    private final ModelPart otherTail_r1;
    private final ModelPart otherTail_r2;
    private final ModelPart otherTail_r3;
    private final ModelPart otherTail_r4;
    private final ModelPart extraTail;
    private final ModelPart tail7;
    private float betweenFloater;
    private float startFlyingTicker;
    private boolean endFlying;
    private int endFlyingTicker;
    private boolean randomYawFire;
    private int randomYawFireTick;

    public DragonModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.spike = this.body.m_171324_("spike");
        this.chest = this.body.m_171324_("chest");
        this.wingLeft = root.m_171324_("wingLeft");
        this.wingTipLeft = this.wingLeft.m_171324_("wingTipLeft");
        this.wingRight = root.m_171324_("wingRight");
        this.wingTipRight = this.wingRight.m_171324_("wingTipRight");
        this.rearLegRight = root.m_171324_("rearLegRight");
        this.rearLegRightTip = this.rearLegRight.m_171324_("rearLegRightTip");
        this.rearFootRight = this.rearLegRightTip.m_171324_("rearFootRight");
        this.rearLegRightTip_r1 = this.rearLegRightTip.m_171324_("rearLegRightTip_r1");
        this.rearLegLeft = root.m_171324_("rearLegLeft");
        this.rearLegLefttip = this.rearLegLeft.m_171324_("rearLegLefttip");
        this.rearFootLeft = this.rearLegLefttip.m_171324_("rearFootLeft");
        this.rearLegLefttip_r1 = this.rearLegLefttip.m_171324_("rearLegLefttip_r1");
        this.frontLegRight = root.m_171324_("frontLegRight");
        this.frontLegRighttip = this.frontLegRight.m_171324_("frontLegRighttip");
        this.frontFootRight = this.frontLegRighttip.m_171324_("frontFootRight");
        this.frontLegRighttip_r1 = this.frontLegRighttip.m_171324_("frontLegRighttip_r1");
        this.frontLegRight_r1 = this.frontLegRight.m_171324_("frontLegRight_r1");
        this.frontLegLeft = root.m_171324_("frontLegLeft");
        this.frontLegLefttip = this.frontLegLeft.m_171324_("frontLegLefttip");
        this.frontFootLeft = this.frontLegLefttip.m_171324_("frontFootLeft");
        this.frontLegLefttip_r1 = this.frontLegLefttip.m_171324_("frontLegLefttip_r1");
        this.frontLegLeft_r1 = this.frontLegLeft.m_171324_("frontLegLeft_r1");
        this.neck = root.m_171324_("neck");
        this.neck2 = this.neck.m_171324_("neck2");
        this.neck3 = this.neck2.m_171324_("neck3");
        this.neck4 = this.neck3.m_171324_("neck4");
        this.head = this.neck4.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.ears = this.head.m_171324_("ears");
        this.otherEars = this.head.m_171324_("otherEars");
        this.otherEars_r2 = this.otherEars.m_171324_("otherEars_r2");
        this.otherEars_r1 = this.otherEars.m_171324_("otherEars_r1");
        this.tail = root.m_171324_("tail");
        this.tail2 = this.tail.m_171324_("tail2");
        this.tail3 = this.tail2.m_171324_("tail3");
        this.tail4 = this.tail3.m_171324_("tail4");
        this.tail5 = this.tail4.m_171324_("tail5");
        this.tail6 = this.tail5.m_171324_("tail6");
        this.tail7 = this.tail6.m_171324_("tail7");
        this.extraTail = this.tail6.m_171324_("extraTail");
        this.otherTail = this.tail6.m_171324_("otherTail");
        this.otherTail_r4 = this.otherTail.m_171324_("otherTail_r4");
        this.otherTail_r3 = this.otherTail.m_171324_("otherTail_r3");
        this.otherTail_r2 = this.otherTail.m_171324_("otherTail_r2");
        this.otherTail_r1 = this.otherTail.m_171324_("otherTail_r1");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartData1 = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 168).m_171481_(-12.0f, -11.0f, -32.0f, 24.0f, 24.0f, 64.0f).m_171514_(116, 256).m_171481_(-1.0f, -17.0f, -26.0f, 2.0f, 6.0f, 12.0f).m_171514_(60, 256).m_171481_(-1.0f, -17.0f, 14.0f, 2.0f, 6.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)-2.0f));
        modelPartData1.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(252, 196).m_171481_(-15.0f, -11.0f, 0.0f, 3.0f, 12.0f, 14.0f).m_171514_(247, 86).m_171481_(12.0f, -11.0f, 0.0f, 3.0f, 12.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        modelPartData1.m_171599_("spike", CubeListBuilder.m_171558_().m_171514_(88, 256).m_171481_(-1.0f, -6.0f, -5.0f, 2.0f, 6.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)-1.0f));
        PartDefinition modelPartData2 = modelPartData.m_171599_("wingLeft", CubeListBuilder.m_171558_().m_171514_(168, 0).m_171481_(-56.0f, -4.0f, -4.0f, 56.0f, 8.0f, 8.0f).m_171514_(112, 112).m_171481_(-56.0f, 0.0f, 2.0f, 56.0f, 0.0f, 56.0f), PartPose.m_171419_((float)-12.0f, (float)-18.0f, (float)-24.0f));
        modelPartData2.m_171599_("wingTipLeft", CubeListBuilder.m_171558_().m_171514_(168, 24).m_171481_(-56.0f, -3.0f, -2.0f, 56.0f, 4.0f, 4.0f).m_171514_(0, 112).m_171481_(-56.0f, 0.0f, 2.0f, 56.0f, 0.0f, 56.0f), PartPose.m_171419_((float)-56.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartData3 = modelPartData.m_171599_("wingRight", CubeListBuilder.m_171558_().m_171514_(112, 168).m_171481_(0.0f, -4.0f, -4.0f, 56.0f, 8.0f, 8.0f).m_171514_(0, 56).m_171481_(0.0f, 0.0f, 2.0f, 56.0f, 0.0f, 56.0f), PartPose.m_171419_((float)12.0f, (float)-18.0f, (float)-24.0f));
        modelPartData3.m_171599_("wingTipRight", CubeListBuilder.m_171558_().m_171514_(168, 16).m_171481_(0.0f, -3.0f, -2.0f, 56.0f, 4.0f, 4.0f).m_171514_(0, 0).m_171481_(0.0f, 0.0f, 2.0f, 56.0f, 0.0f, 56.0f), PartPose.m_171419_((float)56.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartData4 = modelPartData.m_171599_("rearLegRight", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171481_(-8.0f, -4.2322f, -6.0798f, 12.0f, 28.0f, 12.0f), PartPose.m_171419_((float)16.0f, (float)-5.0f, (float)22.0f));
        PartDefinition modelPartData5 = modelPartData4.m_171599_("rearLegRightTip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)20.327f, (float)1.5816f));
        modelPartData5.m_171599_("rearLegRightTip_r1", CubeListBuilder.m_171558_().m_171514_(176, 184).m_171481_(-6.0f, -7.5f, -7.0f, 10.0f, 32.0f, 11.0f), PartPose.m_171419_((float)0.0f, (float)1.1105f, (float)-0.517f));
        modelPartData5.m_171599_("rearFootRight", CubeListBuilder.m_171558_().m_171514_(168, 66).m_171481_(-5.0f, 0.0f, -15.0f, 12.0f, 6.0f, 19.0f), PartPose.m_171419_((float)-2.0f, (float)16.0502f, (float)14.6409f));
        PartDefinition modelPartData6 = modelPartData.m_171599_("rearLegLeft", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -5.1472f, -5.6383f, 12.0f, 28.0f, 12.0f), PartPose.m_171419_((float)-16.0f, (float)-5.0f, (float)21.0f));
        PartDefinition modelPartData7 = modelPartData6.m_171599_("rearLegLefttip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)19.9876f, (float)2.1028f));
        modelPartData7.m_171599_("rearLegLefttip_r1", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171481_(-4.0f, -6.6164f, -6.486f, 10.0f, 32.0f, 11.0f), PartPose.m_171419_((float)-1.0f, (float)0.6549f, (float)-0.4294f));
        modelPartData7.m_171599_("rearFootLeft", CubeListBuilder.m_171558_().m_171514_(0, 182).m_171481_(-6.0f, 0.3f, -14.7f, 12.0f, 6.0f, 19.0f), PartPose.m_171419_((float)0.0f, (float)15.6549f, (float)15.0706f));
        PartDefinition modelPartData8 = modelPartData.m_171599_("frontLegRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)12.0f, (float)-3.0f, (float)-25.0f));
        modelPartData8.m_171599_("frontLegRight_r1", CubeListBuilder.m_171558_().m_171514_(252, 32).m_171481_(-4.0f, -38.2535f, -12.1057f, 8.0f, 24.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)30.8475f, (float)16.5052f));
        PartDefinition modelPartData9 = modelPartData8.m_171599_("frontLegRighttip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.207f, (float)-0.1549f));
        modelPartData9.m_171599_("frontLegRighttip_r1", CubeListBuilder.m_171558_().m_171514_(0, 256).m_171481_(-2.9f, 3.0f, -39.0f, 7.0f, 17.0f, 8.0f), PartPose.m_171419_((float)-1.0f, (float)-16.207f, (float)32.1549f));
        modelPartData9.m_171599_("frontFootRight", CubeListBuilder.m_171558_().m_171514_(256, 256).m_171481_(-4.8f, 0.0f, -15.1665f, 7.0f, 5.0f, 8.0f).m_171514_(240, 168).m_171481_(-4.8f, -1.0f, -7.1665f, 7.0f, 6.0f, 8.0f), PartPose.m_171419_((float)1.0f, (float)10.793f, (float)3.1549f));
        PartDefinition modelPartData10 = modelPartData.m_171599_("frontLegLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-12.0f, (float)-3.0f, (float)-25.0f));
        modelPartData10.m_171599_("frontLegLeft_r1", CubeListBuilder.m_171558_().m_171514_(224, 238).m_171481_(-4.0f, -38.2535f, -12.1057f, 8.0f, 24.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)30.8475f, (float)16.5052f));
        PartDefinition modelPartData11 = modelPartData10.m_171599_("frontLegLefttip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)15.4023f, (float)0.2817f));
        modelPartData11.m_171599_("frontLegLefttip_r1", CubeListBuilder.m_171558_().m_171514_(30, 256).m_171481_(-4.9f, 4.0f, -37.0f, 7.0f, 17.0f, 8.0f), PartPose.m_171419_((float)1.0f, (float)-16.4023f, (float)30.7183f));
        modelPartData11.m_171599_("frontFootLeft", CubeListBuilder.m_171558_().m_171514_(256, 243).m_171481_(-3.8f, -0.3f, -14.4825f, 7.0f, 5.0f, 8.0f).m_171514_(144, 256).m_171481_(-3.8f, -1.3f, -6.4825f, 7.0f, 6.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)12.1611f, (float)3.9136f));
        PartDefinition modelPartData12 = modelPartData.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(218, 184).m_171481_(-7.0f, -8.0f, -10.0f, 14.0f, 16.0f, 10.0f).m_171514_(168, 66).m_171481_(-1.0f, -12.0f, -8.0f, 2.0f, 5.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-34.0f));
        PartDefinition modelPartData13 = modelPartData12.m_171599_("neck2", CubeListBuilder.m_171558_().m_171514_(0, 207).m_171481_(-7.0f, -7.0f, -10.0f, 14.0f, 15.0f, 10.0f).m_171514_(168, 32).m_171481_(-1.0f, -11.0f, -8.0f, 2.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-10.0f));
        PartDefinition modelPartData14 = modelPartData13.m_171599_("neck3", CubeListBuilder.m_171558_().m_171514_(112, 207).m_171481_(-7.0f, -7.0f, -10.0f, 14.0f, 14.0f, 10.0f).m_171514_(39, 117).m_171481_(-1.0f, -11.0f, -8.0f, 2.0f, 7.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-10.0f));
        PartDefinition modelPartData15 = modelPartData14.m_171599_("neck4", CubeListBuilder.m_171558_().m_171514_(176, 238).m_171481_(-7.0f, -6.0f, -10.0f, 14.0f, 12.0f, 10.0f).m_171514_(0, 182).m_171481_(-1.0f, -10.0f, -8.0f, 2.0f, 5.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-10.0f));
        PartDefinition modelPartData16 = modelPartData15.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(112, 184).m_171481_(-8.0f, -3.0f, -30.0f, 16.0f, 7.0f, 16.0f).m_171514_(168, 32).m_171481_(-10.0f, -10.0f, -16.0f, 20.0f, 18.0f, 16.0f).m_171514_(39, 130).m_171481_(2.0f, -5.0f, -28.0f, 3.0f, 4.0f, 4.0f).m_171514_(0, 123).m_171481_(-5.0f, -5.0f, -28.0f, 3.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-10.0f));
        PartDefinition modelPartData17 = modelPartData16.m_171599_("otherEars", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)-7.0f));
        modelPartData17.m_171599_("otherEars_r1", CubeListBuilder.m_171558_().m_171514_(42, 80).m_171481_(-2.0f, -13.0f, -1.0f, 4.0f, 15.0f, 3.0f), PartPose.m_171419_((float)5.0f, (float)0.0f, (float)0.0f));
        modelPartData17.m_171599_("otherEars_r2", CubeListBuilder.m_171558_().m_171514_(42, 98).m_171481_(-2.0f, -13.0f, -1.0f, 4.0f, 15.0f, 3.0f), PartPose.m_171419_((float)-5.0f, (float)0.0f, (float)0.0f));
        modelPartData16.m_171599_("ears", CubeListBuilder.m_171558_().m_171514_(194, 260).m_171481_(8.0f, -5.0f, -4.0f, 4.0f, 7.0f, 6.0f).m_171514_(174, 260).m_171481_(-2.0f, -5.0f, -4.0f, 4.0f, 7.0f, 6.0f), PartPose.m_171419_((float)-5.0f, (float)-10.0f, (float)-6.0f));
        modelPartData16.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(168, 91).m_171481_(-6.0f, -2.0f, -14.0f, 12.0f, 4.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-16.0f));
        PartDefinition modelPartData18 = modelPartData.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 153).m_171481_(-7.0f, -7.0f, -1.0f, 14.0f, 14.0f, 15.0f).m_171514_(160, 219).m_171481_(-1.0f, -12.0f, 3.0f, 2.0f, 5.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)30.0f));
        PartDefinition modelPartData19 = modelPartData18.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(0, 123).m_171481_(-6.0f, -6.0f, -1.0f, 12.0f, 12.0f, 15.0f).m_171514_(36, 40).m_171481_(-1.0f, -10.0f, 3.0f, 2.0f, 4.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)14.0f));
        PartDefinition modelPartData20 = modelPartData19.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(203, 212).m_171481_(-5.0f, -6.0f, -1.0f, 10.0f, 11.0f, 15.0f).m_171514_(36, 0).m_171481_(-1.0f, -10.0f, 2.0f, 2.0f, 4.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)14.0f));
        PartDefinition modelPartData21 = modelPartData20.m_171599_("tail4", CubeListBuilder.m_171558_().m_171514_(215, 76).m_171481_(-2.0f, -5.0f, -1.0f, 8.0f, 9.0f, 15.0f).m_171514_(238, 214).m_171481_(1.0f, -8.0f, 3.0f, 2.0f, 3.0f, 8.0f), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)14.0f));
        PartDefinition modelPartData22 = modelPartData21.m_171599_("tail5", CubeListBuilder.m_171558_().m_171514_(225, 51).m_171481_(-3.0f, -4.0f, -1.0f, 6.0f, 8.0f, 15.0f).m_171514_(176, 227).m_171481_(-1.0f, -7.0f, 3.0f, 2.0f, 3.0f, 8.0f), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)14.0f));
        PartDefinition modelPartData23 = modelPartData22.m_171599_("tail6", CubeListBuilder.m_171558_().m_171514_(248, 223).m_171481_(0.0f, -2.0f, -1.0f, 4.0f, 5.0f, 15.0f).m_171514_(160, 184).m_171481_(1.0f, -5.0f, 3.0f, 2.0f, 3.0f, 8.0f), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)14.0f));
        PartDefinition modelPartData24 = modelPartData23.m_171599_("otherTail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)8.0f));
        modelPartData24.m_171599_("otherTail_r1", CubeListBuilder.m_171558_().m_171514_(38, 207).m_171481_(-12.0f, -1.0f, -1.0f, 11.0f, 2.0f, 2.0f), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        modelPartData24.m_171599_("otherTail_r2", CubeListBuilder.m_171558_().m_171514_(206, 100).m_171481_(1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        modelPartData24.m_171599_("otherTail_r3", CubeListBuilder.m_171558_().m_171514_(150, 207).m_171481_(-12.0f, -1.0f, -1.0f, 11.0f, 2.0f, 2.0f), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)-6.0f));
        modelPartData24.m_171599_("otherTail_r4", CubeListBuilder.m_171558_().m_171514_(218, 107).m_171481_(1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)-6.0f));
        modelPartData23.m_171599_("extraTail", CubeListBuilder.m_171558_().m_171514_(210, 32).m_171481_(4.0f, 0.0f, -7.0f, 11.0f, 0.0f, 14.0f).m_171514_(29, 182).m_171481_(-10.0f, 0.0f, -7.0f, 10.0f, 0.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.0f));
        modelPartData23.m_171599_("tail7", CubeListBuilder.m_171558_().m_171514_(252, 64).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 15.0f).m_171514_(0, 0).m_171481_(0.0f, -3.0f, 5.0f, 0.0f, 2.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)14.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)512, (int)512);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.body, (Object)this.wingLeft, (Object)this.wingRight, (Object)this.rearLegLeft, (Object)this.rearLegRight, (Object)this.frontLegLeft, (Object)this.frontLegRight, (Object)this.neck, (Object)this.tail);
    }

    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.renderExtras((Entity)entity);
        this.otherEars.f_104203_ = -1.0036f;
        this.otherEars_r1.f_104203_ = 0.1745f;
        this.otherEars_r1.f_104205_ = 0.2182f;
        this.otherEars_r2.f_104203_ = 0.1745f;
        this.otherEars_r2.f_104205_ = -0.2182f;
        this.otherTail_r1.f_104204_ = 0.7418f;
        this.otherTail_r2.f_104204_ = -0.7418f;
        this.otherTail_r3.f_104204_ = 0.6109f;
        this.otherTail_r4.f_104204_ = -0.7418f;
        this.rearLegRight.f_104203_ = -0.9599f;
        this.rearLegRightTip.f_104203_ = 1.309f;
        this.rearLegRightTip_r1.f_104203_ = 0.9599f;
        this.rearFootRight.f_104203_ = -0.3491f;
        this.rearLegLeft.f_104203_ = -0.9599f;
        this.rearLegLefttip.f_104203_ = 1.309f;
        this.rearLegLefttip_r1.f_104203_ = 0.9599f;
        this.rearFootLeft.f_104203_ = -0.3491f;
        this.frontLegRight.f_104203_ = 0.3491f;
        this.frontLegRight_r1.f_104203_ = 0.2618f;
        this.frontLegRighttip.f_104203_ = -1.5708f;
        this.frontLegRighttip_r1.f_104203_ = 0.2618f;
        this.frontFootRight.f_104203_ = 1.2217f;
        this.frontLegLeft.f_104203_ = 0.3491f;
        this.frontLegLeft_r1.f_104203_ = 0.2618f;
        this.frontLegLefttip.f_104203_ = -1.5708f;
        this.frontLegLefttip_r1.f_104203_ = 0.2618f;
        this.frontFootLeft.f_104203_ = 1.2217f;
        this.head.f_104204_ = headYaw * 0.002908882f;
        this.head.f_104203_ = headPitch * 0.003745329f;
        this.neck.f_104204_ = headYaw * 0.0034906585f;
        this.neck2.f_104204_ = headYaw * 0.0034906585f;
        this.neck3.f_104204_ = headYaw * 0.004363323f;
        this.neck4.f_104204_ = headYaw * 0.004363323f;
        this.neck.f_104203_ = headPitch * 0.0017453292f;
        this.neck2.f_104203_ = headPitch * 0.0017453292f;
        this.neck3.f_104203_ = headPitch * 0.0017453292f;
        this.neck4.f_104203_ = headPitch * 0.0017453292f;
        Boolean isFireBreathing = (Boolean)entity.m_20088_().m_135370_(DragonEntity.FIRE_BREATH);
        if (isFireBreathing.booleanValue()) {
            this.jaw.f_104203_ = 0.4f;
        }
        float slowlyIncreasingFloat = ((float)Math.floorMod(entity.m_9236_().m_46467_(), 100L) + animationProgress) / 100.0f;
        if (((Boolean)entity.m_20088_().m_135370_(DragonEntity.CLIENT_START_FLYING)).booleanValue()) {
            this.startFlyingTicker = (Boolean)entity.m_20088_().m_135370_(DragonEntity.IS_START_FLYING) != false ? Mth.m_14036_((float)(this.startFlyingTicker + 0.05164f), (float)0.0f, (float)1.4981f) : Mth.m_14036_((float)(this.startFlyingTicker - 0.05164f), (float)0.0f, (float)1.4981f);
            this.wingRight.f_104205_ = 0.6981f - this.startFlyingTicker;
            this.wingLeft.f_104205_ = -0.6981f + this.startFlyingTicker;
            this.wingTipLeft.f_104205_ = 2.618f - this.startFlyingTicker * 1.3203391f;
            this.wingTipRight.f_104205_ = -2.618f + this.startFlyingTicker * 1.3203391f;
            this.betweenFloater = (float)Math.PI * 4 * slowlyIncreasingFloat;
            if (entity.m_20096_()) {
                float walkFloat = 32.0f;
                this.rearLegRight.f_104203_ = -0.9599f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.rearLegLeft.f_104203_ = -0.9599f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.rearFootRight.f_104203_ = -0.3491f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.9f;
                this.rearFootLeft.f_104203_ = -0.3491f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.9f;
                this.frontLegRight.f_104203_ = 0.3491f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.frontLegLeft.f_104203_ = 0.3491f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.frontLegRighttip.f_104203_ = -1.5708f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.8f;
                this.frontLegLefttip.f_104203_ = -1.5708f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.8f;
                this.frontFootRight.f_104203_ = 1.2217f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.2f;
                this.frontFootLeft.f_104203_ = 1.2217f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.2f;
            }
        } else if (((Boolean)entity.m_20088_().m_135370_(DragonEntity.IS_FLYING)).booleanValue()) {
            float bodyFloating;
            this.startFlyingTicker = 0.0f;
            float mediumSpeedSin = Mth.m_14089_((float)((float)Math.PI * 4 * slowlyIncreasingFloat - (this.betweenFloater + (float)Math.PI)));
            this.wingRight.f_104205_ = mediumSpeedSin * 0.8f;
            this.wingTipRight.f_104205_ = this.wingRight.f_104205_ * 0.8f;
            this.wingLeft.f_104205_ = -this.wingRight.f_104205_;
            this.wingTipLeft.f_104205_ = -this.wingTipRight.f_104205_;
            this.body.f_104201_ = bodyFloating = -mediumSpeedSin - 4.0f;
            this.wingLeft.f_104201_ = bodyFloating - 10.0f;
            this.wingRight.f_104201_ = bodyFloating - 10.0f;
            this.rearLegLeft.f_104201_ = bodyFloating;
            this.rearLegRight.f_104201_ = bodyFloating;
            this.frontLegLeft.f_104201_ = bodyFloating;
            this.frontLegRight.f_104201_ = bodyFloating;
            this.neck.f_104201_ = bodyFloating;
            this.tail.f_104201_ = bodyFloating;
            float headFloat = Mth.m_14089_((float)(bodyFloating / 2.0f));
            this.neck2.f_104201_ = -headFloat;
            this.neck3.f_104201_ = -headFloat;
            this.neck4.f_104201_ = -headFloat * 0.9f;
            this.head.f_104201_ = -headFloat * 0.8f;
            if (!isFireBreathing.booleanValue()) {
                this.jaw.f_104203_ = -headFloat * 0.3f;
            }
            this.tail2.f_104201_ = Mth.m_14089_((float)((float)Math.PI * 2 * slowlyIncreasingFloat - 2.0943952f));
            this.tail3.f_104201_ = Mth.m_14089_((float)((float)Math.PI * 2 * slowlyIncreasingFloat - 2.0943952f));
            this.tail4.f_104201_ = Mth.m_14089_((float)((float)Math.PI * 2 * slowlyIncreasingFloat - 1.5707964f));
            this.tail5.f_104201_ = Mth.m_14089_((float)((float)Math.PI * 2 * slowlyIncreasingFloat - 1.5707964f));
            this.tail5.f_104201_ = Mth.m_14089_((float)((float)Math.PI * 2 * slowlyIncreasingFloat - 1.2566371f));
            this.tail6.f_104201_ = Mth.m_14089_((float)((float)Math.PI * 2 * slowlyIncreasingFloat - 1.2566371f));
            this.tail7.f_104201_ = Mth.m_14089_((float)((float)Math.PI * 2 * slowlyIncreasingFloat - 1.0471976f)) * 0.5f;
            if (entity.m_20096_()) {
                float walkFloat = 32.0f;
                this.rearLegRight.f_104203_ = -0.9599f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.rearLegLeft.f_104203_ = -0.9599f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.rearFootRight.f_104203_ = -0.3491f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.9f;
                this.rearFootLeft.f_104203_ = -0.3491f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.9f;
                this.frontLegRight.f_104203_ = 0.3491f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.frontLegLeft.f_104203_ = 0.3491f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.frontLegRighttip.f_104203_ = -1.5708f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.8f;
                this.frontLegLefttip.f_104203_ = -1.5708f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.8f;
                this.frontFootRight.f_104203_ = 1.2217f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.2f;
                this.frontFootLeft.f_104203_ = 1.2217f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.2f;
            } else {
                this.rearLegRight.f_104203_ = 0.5672f;
                this.rearLegRightTip.f_104203_ = -0.2182f;
                this.rearLegRightTip_r1.f_104203_ = 0.9599f;
                this.rearFootRight.f_104203_ = 1.4835f;
                this.rearLegLeft.f_104203_ = 0.5672f;
                this.rearLegLefttip.f_104203_ = -0.2182f;
                this.rearLegLefttip_r1.f_104203_ = 0.9599f;
                this.rearFootLeft.f_104203_ = 1.4835f;
                this.frontLegRight.f_104203_ = 0.7418f;
                this.frontLegRight_r1.f_104203_ = 0.2618f;
                this.frontLegRighttip.f_104203_ = -1.0472f;
                this.frontLegRighttip_r1.f_104203_ = 0.2618f;
                this.frontFootRight.f_104203_ = 1.4835f;
                this.frontLegLeft.f_104203_ = 0.7418f;
                this.frontLegLeft_r1.f_104203_ = 0.2618f;
                this.frontLegLefttip.f_104203_ = -1.0472f;
                this.frontLegLefttip_r1.f_104203_ = 0.2618f;
                this.frontFootLeft.f_104203_ = 1.4835f;
            }
        } else if (((Boolean)entity.m_20088_().m_135370_(DragonEntity.CLIENT_END_FLYING)).booleanValue()) {
            float mediumSpeedSin = Mth.m_14089_((float)((float)Math.PI * 4 * slowlyIncreasingFloat - (this.betweenFloater + (float)Math.PI)));
            if (mediumSpeedSin < 0.04f && mediumSpeedSin > -0.04f) {
                this.endFlying = true;
            }
            if (!this.endFlying) {
                this.wingRight.f_104205_ = mediumSpeedSin * 0.8f;
                this.wingTipRight.f_104205_ = this.wingRight.f_104205_ * 0.8f;
                this.wingLeft.f_104205_ = -this.wingRight.f_104205_;
                this.wingTipLeft.f_104205_ = -this.wingTipRight.f_104205_;
            } else {
                ++this.endFlyingTicker;
                if (this.endFlyingTicker <= 10) {
                    this.wingRight.f_104205_ = this.startFlyingTicker = Mth.m_14036_((float)(this.startFlyingTicker + 0.06205f), (float)0.0f, (float)0.6981f);
                    this.wingLeft.f_104205_ = -this.startFlyingTicker;
                    this.wingTipLeft.f_104205_ = this.startFlyingTicker * 3.750179f;
                    this.wingTipRight.f_104205_ = -(this.startFlyingTicker * 3.750179f);
                } else {
                    entity.m_20088_().m_135381_(DragonEntity.CLIENT_END_FLYING, (Object)false);
                    this.endFlyingTicker = 0;
                    this.startFlyingTicker = 0.0f;
                    this.endFlying = false;
                }
            }
            if (entity.m_20096_()) {
                float walkFloat = 32.0f;
                this.rearLegRight.f_104203_ = -0.9599f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.rearLegLeft.f_104203_ = -0.9599f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.rearFootRight.f_104203_ = -0.3491f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.9f;
                this.rearFootLeft.f_104203_ = -0.3491f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.9f;
                this.frontLegRight.f_104203_ = 0.3491f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.frontLegLeft.f_104203_ = 0.3491f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
                this.frontLegRighttip.f_104203_ = -1.5708f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.8f;
                this.frontLegLefttip.f_104203_ = -1.5708f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.8f;
                this.frontFootRight.f_104203_ = 1.2217f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.2f;
                this.frontFootLeft.f_104203_ = 1.2217f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.2f;
            }
        } else if (!((DragonEntity)((Object)entity)).isInSittingPose() || entity.m_20160_()) {
            float walkFloat = 32.0f;
            this.rearLegRight.f_104203_ = -0.9599f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
            this.rearLegLeft.f_104203_ = -0.9599f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
            this.rearFootRight.f_104203_ = -0.3491f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.9f;
            this.rearFootLeft.f_104203_ = -0.3491f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.9f;
            this.frontLegRight.f_104203_ = 0.3491f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
            this.frontLegLeft.f_104203_ = 0.3491f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f;
            this.frontLegRighttip.f_104203_ = -1.5708f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.8f;
            this.frontLegLefttip.f_104203_ = -1.5708f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.8f;
            this.frontFootRight.f_104203_ = 1.2217f + 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.2f;
            this.frontFootLeft.f_104203_ = 1.2217f - 0.3f * Mth.m_14156_((float)limbAngle, (float)walkFloat) * limbDistance * 1.3f * 0.2f;
            this.tail.f_104203_ = -0.1309f;
            this.tail2.f_104203_ = -0.1309f;
            this.tail3.f_104203_ = -0.1309f;
            this.tail4.f_104203_ = -0.1745f;
            this.tail5.f_104203_ = 0.1309f;
            this.tail6.f_104203_ = 0.1745f;
            this.tail7.f_104203_ = 0.2618f;
            this.tail.f_104204_ = 0.0436f * Mth.m_14156_((float)limbAngle, (float)60.0f) * limbDistance;
            this.tail2.f_104204_ = 0.0436f * Mth.m_14156_((float)limbAngle, (float)60.0f) * limbDistance;
            this.tail3.f_104204_ = 0.0436f * Mth.m_14156_((float)limbAngle, (float)60.0f) * limbDistance;
            this.tail4.f_104204_ = 0.0436f * Mth.m_14156_((float)limbAngle, (float)60.0f) * limbDistance;
            this.tail5.f_104204_ = 0.0436f * Mth.m_14156_((float)limbAngle, (float)70.0f) * limbDistance;
            this.tail6.f_104204_ = 0.0436f * Mth.m_14156_((float)limbAngle, (float)70.0f) * limbDistance;
            this.tail7.f_104204_ = 0.0436f * Mth.m_14156_((float)limbAngle, (float)80.0f) * limbDistance;
            this.tail2.f_104201_ = 0.0f;
            this.tail3.f_104201_ = 0.0f;
            this.tail4.f_104201_ = 0.0f;
            this.tail5.f_104201_ = 0.0f;
            this.tail5.f_104201_ = 0.0f;
            this.tail6.f_104201_ = 0.0f;
            this.tail7.f_104201_ = 0.0f;
            this.wingLeft.f_104205_ = -0.6981f + 0.0236f * Mth.m_14156_((float)limbAngle, (float)40.0f) * limbDistance;
            this.wingTipLeft.f_104205_ = 2.618f;
            this.wingRight.f_104205_ = 0.6981f - 0.0236f * Mth.m_14156_((float)limbAngle, (float)40.0f) * limbDistance;
            this.wingTipRight.f_104205_ = -2.618f;
            if (!isFireBreathing.booleanValue()) {
                this.jaw.f_104203_ = 0.0f;
            }
        } else {
            this.tail.f_104203_ = -0.1309f;
            this.tail2.f_104203_ = -0.1309f;
            this.tail3.f_104203_ = -0.1309f;
            this.tail4.f_104203_ = -0.1745f;
            this.tail5.f_104203_ = 0.1309f;
            this.tail6.f_104203_ = 0.1745f;
            this.tail7.f_104203_ = 0.1745f;
            this.tail.f_104204_ = -0.0436f;
            this.tail2.f_104204_ = -0.0436f;
            this.tail3.f_104204_ = -0.0873f;
            this.tail4.f_104204_ = -0.0436f;
            this.tail5.f_104204_ = -0.2182f;
            this.tail6.f_104204_ = -0.2182f;
            this.tail6.f_104205_ = -0.0436f;
            this.tail7.f_104205_ = -0.1309f;
            this.wingLeft.f_104205_ = -0.6981f;
            this.wingTipLeft.f_104205_ = 2.618f;
            this.wingRight.f_104205_ = 0.6981f;
            this.wingTipRight.f_104205_ = -2.618f;
            Float yawPitch = Float.valueOf(Math.abs(Mth.m_14089_((float)((float)Math.PI * 2 * slowlyIncreasingFloat)) * 0.3f));
            if (((DragonEntity)((Object)entity)).getSize() == 3 && !this.randomYawFire && yawPitch.floatValue() <= 0.01f && entity.m_9236_().f_46441_.m_188503_(16) == 0 && !isFireBreathing.booleanValue()) {
                this.randomYawFire = true;
            }
            if (this.randomYawFire) {
                ++this.randomYawFireTick;
                Float yawler = Float.valueOf(this.head.f_104204_ + this.neck.f_104204_ + this.neck2.f_104204_ + this.neck3.f_104204_ + this.neck4.f_104204_);
                Float pitcher = Float.valueOf(this.head.f_104203_ + this.neck.f_104203_ + this.neck2.f_104203_ + this.neck3.f_104203_ + this.neck4.f_104203_);
                yawler = Float.valueOf(yawler.floatValue() / (float)Math.PI * 1.5f);
                pitcher = Float.valueOf(pitcher.floatValue() * 3.0f);
                entity.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, entity.m_20185_() + Math.sin((double)(((DragonEntity)((Object)entity)).f_20883_ / 360.0f * 2.0f) * Math.PI + Math.PI + (double)yawler.floatValue()) * 6.0, entity.m_20186_() - (double)pitcher.floatValue() + 1.95, entity.m_20189_() - Math.cos((double)(((DragonEntity)((Object)entity)).f_20883_ / 360.0f * 2.0f) * Math.PI + Math.PI + (double)yawler.floatValue()) * 6.0, 0.0, 0.0, 0.0);
                this.jaw.f_104203_ = yawPitch.floatValue();
                if (this.randomYawFireTick > 10 && yawPitch.floatValue() <= 0.01f || isFireBreathing.booleanValue()) {
                    this.randomYawFireTick = 0;
                    this.randomYawFire = false;
                }
            }
        }
    }

    private void renderExtras(Entity entity) {
        this.spike.f_104207_ = (Boolean)entity.m_20088_().m_135370_(DragonEntity.HAS_SADDLE) == false;
        this.chest.f_104207_ = (Boolean)entity.m_20088_().m_135370_(DragonEntity.HAS_CHEST) != false;
        if (((Boolean)entity.m_20088_().m_135370_(DragonEntity.OTHER_EARS)).booleanValue()) {
            this.otherEars.f_104207_ = true;
            this.ears.f_104207_ = false;
        } else {
            this.otherEars.f_104207_ = false;
            this.ears.f_104207_ = true;
        }
        if (((Boolean)entity.m_20088_().m_135370_(DragonEntity.OTHER_TAIL)).booleanValue()) {
            this.otherTail.f_104207_ = true;
            this.extraTail.f_104207_ = false;
        } else {
            this.otherTail.f_104207_ = false;
            this.extraTail.f_104207_ = true;
        }
    }
}

